const filterSubmit = document.getElementById("filterSubmit");
const tableFiltered = document.getElementById("table-filtered");
const totalQuantity = document.getElementById("total_quantity");
const totalAmount = document.getElementById("total_amount");

filterSubmit.addEventListener("submit", (e) => {
    e.preventDefault();

    const from_date = document.getElementById("from_date").value;
    const to_date = document.getElementById("to_date").value;

    let formData = new FormData();
    formData.append("from_date", from_date);
    formData.append("to_date", to_date);

    fetch("../pages/submissions/salesFilter.php", {
        method: "POST",
        body: formData
    })
    .then(res => res.json())
    .then(data => { 

        const tbody = document.getElementById("table-filtered");
        tbody.innerHTML = ""; // CLEAR old rows

        if (data.length === 0) {
            tbody.innerHTML = "<tr><td colspan='7' class='text-center'>No records found</td></tr>";
            return;
        }

        data.forEach(row => {
            const tr = document.createElement("tr");
            tr.classList.add("table-light");
            tr.innerHTML = `
                <td>${row.orderid}</td>
                <td>${row.Date}</td>
                <td>${row.OrderType}</td>
                <td>${row.Product_name}</td>
                <td>${row.Price}</td>
                <td>${row.Quantity}</td>
                <td>${row.Amount}</td>
            `;
            tbody.appendChild(tr);
        });

      
        const total_quantity = data.reduce((sum, item) => {
            return sum + Number(item.Quantity);
        }, 0);
        totalQuantity.innerHTML = total_quantity;
        const total_amount = data.reduce((sum, item) => {
            return sum + Number(item.Amount);
        }, 0);

        totalAmount.innerHTML = total_amount;

    });
});
   
    
   
    
        
